#include "TFile.h"
#include "TChain.h"
#include "TH1.h"

#include "gnana/E14GNAnaFunction.h"
#include "gnana/E14GNAnaDataContainer.h"
#include "gamma/GammaFinder.h"
#include "rec2g/Rec2g.h"
#include "CLHEP/Vector/ThreeVector.h"
#include "klong/Klong.h"
#include "pi0/Pi0.h"
#include "gamma/Gamma.h"

#include "KLCalibration.h"

#include <iostream>
#include <cstring>
#include <vector>

int main( int argc, char** argv ){
  if( argc != 2 ){
    std::cout<< "Number of arguement" << std::endl;
    return 0;
  }
  E14GNAnaDataContainer data;

  TChain* itr = new TChain("Tree");
  itr->Add(argv[1]);
  std::string ifilename = argv[1];
  std::string ofilename = ifilename.substr(0, ifilename.rfind(".")) +"_fit.root";  
  data.setBranchAddress( itr );
  
  TFile* otf = new TFile(ofilename.c_str(),"recreate");
  TTree* otr = new TTree("TreeFit","KL position Fit");
  Double_t Chisq;
  TVector3 FitPosition;
  TVector3 InitPosition;
  otr->Branch("Chisq"      ,&Chisq      ,"Chisq/D");
  otr->Branch("FitPosition",&FitPosition,256000,99);
  otr->Branch("InitPosition",&InitPosition,256000,99);



  TH1D* hisDist[3];
  TH1D* hisKL[3];
  for( int i = 0; i< 3; i++){
    hisDist[i] = new TH1D(Form("hisDist_%d",i),
			  Form("Parameter fit displacement %d", i),
			  200,-2,2);
    hisKL[i] = new TH1D(Form("hisKL_%d",i),
			Form("hisKL_%d",i),
			200,-200,200);
  }
  TH1D* hisChi2 = new TH1D("hisChi2","",100,0,10);
  
  for( int ievt = 0;ievt < itr->GetEntries(); ievt++){
    itr->GetEntry( ievt );
    std::cout<< "Event Number " <<  ievt << std::endl;
    std::vector<Klong> klVec;
    std::vector<Klong> klVecKeep;
    data.getData( klVec );
    data.getData( klVecKeep );
    Klong kl = klVec[0];
    Klong kl1 = klVecKeep[0];
    
    TVector3 fitpos(0,0,0);
    Double_t chi2(0);
    Calibrate( kl, fitpos, chi2);    

    std::cout<< kl.vx()  << "\t" << kl1.vx() << std::endl;
    std::cout<< kl.vy()  << "\t" << kl1.vy() << std::endl;
    std::cout<< kl.vz()  << "\t" << kl1.vz() << std::endl;
    FitPosition.SetXYZ( kl.vx(), kl.vy(), kl.vz());
    InitPosition.SetXYZ( kl1.vx(), kl1.vy(), kl1.vz());
    
    Double_t E[6];
    Double_t X[6];
    Double_t Y[6];
    Double_t fitE[6];
    Double_t fitX[6];
    Double_t fitY[6];
    Double_t SE[6];
    Double_t SX[6];
    Double_t SY[6];
    for( int i = 0; i<kl.pi0().size(); i++){
      X[i*2]   = kl1.pi0()[i].g1().x();
      Y[i*2]   = kl1.pi0()[i].g1().y();
      E[i*2]   = kl1.pi0()[i].g1().e();
      X[i*2+1] = kl1.pi0()[i].g2().x();
      Y[i*2+1] = kl1.pi0()[i].g2().y();
      E[i*2+1] = kl1.pi0()[i].g2().e();
      
      fitX[i*2]   = kl.pi0()[i].g1().x();
      fitY[i*2]   = kl.pi0()[i].g1().y();
      fitE[i*2]   = kl.pi0()[i].g1().e();
      fitX[i*2+1] = kl.pi0()[i].g2().x();
      fitY[i*2+1] = kl.pi0()[i].g2().y();
      fitE[i*2+1] = kl.pi0()[i].g2().e();

      SX[i*2]   = kl1.pi0()[i].g1().sigmaX();
      SY[i*2]   = kl1.pi0()[i].g1().sigmaY();
      SE[i*2]   = kl1.pi0()[i].g1().sigmaE();
      SX[i*2+1] = kl1.pi0()[i].g2().sigmaX();
      SY[i*2+1] = kl1.pi0()[i].g2().sigmaY();
      SE[i*2+1] = kl1.pi0()[i].g2().sigmaE();
    }

    for( int i = 0; i< kl.pi0().size()*2; i++){
      hisDist[0]->Fill((fitX[i] - X[i])/SX[i]);
      hisDist[1]->Fill((fitY[i] - Y[i])/SY[i]);
      hisDist[2]->Fill((fitE[i] - E[i])/SE[i]);
    }
    
    //fitpos.Print();
    std::cout<< chi2 << std::endl;
    Chisq       = chi2;
    hisChi2->Fill(chi2);
    otr->Fill();
  }
  hisDist[0]->Write();
  hisDist[1]->Write();
  hisDist[2]->Write();
  hisChi2->Write();
  otr->Write();
  otf->Close();
}
